package cn.quantgroup.tech.brave.interceptor.impl;

import cn.quantgroup.tech.brave.handler.TokenHandler;
import cn.quantgroup.tech.brave.interceptor.HttpClientRequestInterceptor;
import cn.quantgroup.tech.brave.interceptor.RequestInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;

@Slf4j
public class HttpClientAuthRequestInterceptor extends RequestInterceptor implements HttpClientRequestInterceptor {

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        if (auth(((HttpRequestWrapper) httpRequest).getTarget().getHostName())) {
            log.info("cn.quantgroup.tech.brave.interceptor.HttpClientRequestInterceptor.process token = 【{}】 ", TokenHandler.getToken());
            httpRequest.addHeader(AUTH, TokenHandler.getToken());
        }
    }
}
