package cn.quantgroup.tech.brave.configuration;

import brave.Tracer;
import brave.Tracing;
import brave.http.HttpTracing;
import brave.httpclient.TracingHttpClientBuilder;
import brave.okhttp3.TracingInterceptor;
import brave.propagation.B3Propagation;
import brave.propagation.ExtraFieldPropagation;
import brave.spring.web.TracingClientHttpRequestInterceptor;
import brave.spring.webmvc.SpanCustomizingAsyncHandlerInterceptor;
import cn.quantgroup.tech.brave.filter.CustomDelegatingTracingFilter;
import cn.quantgroup.tech.brave.properties.BraveProperties;
import cn.quantgroup.tech.brave.properties.ServiceProperties;
import cn.quantgroup.tech.brave.service.*;
import cn.quantgroup.tech.brave.service.impl.*;
import cn.quantgroup.tech.brave.slf4j.MDCCurrentTraceContext;
import com.dangdang.ddframe.job.api.ElasticJob;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.*;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import zipkin2.Span;
import zipkin2.codec.Encoding;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.kafka11.KafkaSender;

import javax.servlet.Filter;
import java.util.ArrayList;
import java.util.List;

/**
 * 注册brave
 *
 * @author zhangheng
 * create on 2018.04.25
 */
@Slf4j
@Configuration
public class BraveAutoConfiguration {

    @Configuration
    public static class BraveUntEnabled {

        @Configuration
        @ConditionalOnClass(RabbitTemplate.class)
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class RabbitTemplateEnable {
            /**
             * 提供RabbitTemplateBuilder,业务系统需要使用该Builder生成RabbitTemplate
             *
             * @return
             */
            @Bean(name = "techRabbitBuilder")
            public ITechRabbitBuilder techRabbitBuilder() {
                return new TechRabbitBuilderNoTrace();
            }
        }

        @Deprecated
        @Configuration
        @ConditionalOnClass(HttpClient.class)
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class HttpClientEnable {
            /**
             * 提供HttpClientBuilderBean
             *
             * @return
             * @see ITechHttpClient
             */
            @Deprecated
            @Bean(name = "techHttpClientBuilder")
            public HttpClientBuilder httpClientBuilder() {
                log.info("注册HttpClientBuilder");
                return HttpClientBuilder.create();
            }
        }

        @Deprecated
        @Configuration
        @ConditionalOnClass(OkHttpClient.class)
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class OkHttpClientEnable {

            /**
             * 提供OkHttpClientBean
             *
             * @return
             * @see ITechOkHttpClient
             */
            @Deprecated
            @Bean(name = "techOkHttpClientBuilder")
            public OkHttpClient.Builder okHttpClientBuilder() {
                log.info("注册OkHttpClient.Builder");
                return new OkHttpClient.Builder();
            }
        }

        @Deprecated
        @Configuration
        @ConditionalOnClass(RestTemplate.class)
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class RestTemplateEnable {
            /**
             * 提供RestTemplate
             *
             * @return
             * @see ITechRestTemplateBuilder
             */
            @Deprecated
            @Bean(name = "techRestTemplate")
            public RestTemplate restTemplate() {
                log.info("添加restTemplate拦截器");
                return new RestTemplate();
            }
        }

        @Configuration
        @ConditionalOnClass(HttpClient.class)
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class TechHttpClientEnable {
            /**
             * 提供TechHttpClientBuilder
             *
             * @return
             */
            @Bean(name = "techHttpClient")
            public ITechHttpClient techHttpClient() {
                log.info("注册ITechHttpClient, 没有开启brave");
                return new TechHttpClientNoTrace();
            }
        }

        @Configuration
        @ConditionalOnClass(OkHttpClient.class)
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class TechOkHttpClientEnable {

            /**
             * 提供TechOkHttpClient
             *
             * @return
             */
            @Bean(name = "techOkHttpClient")
            public ITechOkHttpClient techOkHttpClient() {
                log.info("注册ITechOkClient, 没有开启brave");
                return new TechOkHttpClientNoTrace();
            }
        }

        @Configuration
        @ConditionalOnClass(RestTemplate.class)
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class TechRestTemplateEnable {
            /**
             * 提供TechRestTemplate
             *
             * @return
             */
            @Bean(name = "techRestTemplateBuilder")
            public ITechRestTemplateBuilder techRestTemplateBuilder() {
                log.info("注册TechRestTemplate, 没有开始brave");
                return new TechRestTemplateBuliderNoTrace();
            }
        }

        @Configuration
        @ConditionalOnProperty(prefix = "tech.brave", name = "enabled", havingValue = "false", matchIfMissing = true)
        public static class TechExecutorServiceEnable {

            @Bean(name = "techExecutorServiceBuilder")
            public ITechExecutorServiceBuilder techExecutorServiceBuilder() {
                return new TechExecutorServiceBuilderNoTrace();
            }
        }
    }

}


