package cn.quantgroup.tech.brave.service.impl;

import cn.quantgroup.tech.brave.service.ITechRabbitBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author zhangheng
 * create on 2018.04.27
 */
@Slf4j
public class TechRabbitBuilderNoTrace implements ITechRabbitBuilder {
    public TechRabbitBuilderNoTrace() {
    }

    @Override
    public RabbitTemplate createRabbitTemplate(ConnectionFactory connectionFactory) {
        log.info("构建RabbitTemplate");
        return new RabbitTemplate(connectionFactory);
    }

    @Override
    public SimpleRabbitListenerContainerFactory createSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        log.info("构建SimpleRabbitListenerContainerFactory");
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        return factory;
    }
}
