package cn.quantgroup.tech.brave.service.impl;

import brave.Tracing;
import brave.httpclient.TracingHttpClientBuilder;
import cn.quantgroup.tech.brave.interceptor.HttpClientRequestInterceptor;
import cn.quantgroup.tech.brave.service.ITechHttpClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.impl.client.HttpClientBuilder;

import javax.annotation.Resource;

/**
 * @author zhangheng
 * create on 2018.05.17
 */
@Slf4j
public class TechHttpClientTrace implements ITechHttpClient {
    private Tracing tracing;

    public TechHttpClientTrace(Tracing tracing) {
        this.tracing = tracing;
    }

    @Resource
    private HttpClientRequestInterceptor httpClientRequestInterceptor;

    @Override
    public HttpClientBuilder createHttpClientBuilder() {
        log.info("构建brave-HttpClientBuilder");
        HttpClientBuilder httpClientBuilder = TracingHttpClientBuilder.create(tracing);
        httpClientBuilder.addInterceptorFirst(httpClientRequestInterceptor);
        return httpClientBuilder;
    }
}
