package cn.quantgroup.boot.tech.db;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.core.annotation.Order;

/**
 * @author ag
 */
@Aspect
@Order(-1)
@Slf4j
public class DynamicDataSourceAspect {


    @Before("@annotation(ds)")
    public void changeDataSource(JoinPoint point, TargetDataSource ds) {
        DSType dsId = ds.type();
        if (!DynamicDataSourceContextHolder.containsDataSource(dsId)) {
            log.error("数据源[{}]不存在，使用默认数据源 > {}", ds.type(), point.getSignature());
            return;
        }
        log.debug("Use DataSource : {} > {}", ds.type(), point.getSignature());
        DynamicDataSourceContextHolder.setDataSourceType(ds.type());
    }

    @After("@annotation(ds)")
    public void restoreDataSource(JoinPoint point, TargetDataSource ds) {
        log.debug("Revert DataSource : {} > {}", ds.type(), point.getSignature());
        DynamicDataSourceContextHolder.clearDataSourceType();
    }

}