package cn.quantgroup.ext.micrometer.register.kafka;

import io.micrometer.core.instrument.Clock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackageClasses = KafkaMeterRegistry.class)
@EnableConfigurationProperties(EnochAgentProperties.class)
@ConditionalOnProperty(prefix = "tech.enoch", name = "enabled", havingValue = "true")
public class MicroMeterKafkaAutoConfiguration {
  private final EnochAgentProperties enochAgentProperties;

  public MicroMeterKafkaAutoConfiguration(
      EnochAgentProperties enochAgentProperties) {
    this.enochAgentProperties = enochAgentProperties;
  }

  @Bean
  public KafkaConfig kafkaConfig() {
    return new
        KafkaConfig() {
          @Override
          public String get(String s) {
            return null;
          }
          @Override
          public String services(){
            return enochAgentProperties.getKafkaHost();
          }
          @Override
          public String topic(){
            return enochAgentProperties.getKafkaTopic();
          }
        };
  }

  @Bean
  public KafkaMeterRegistry kafkaMeterRegistry(KafkaConfig kafkaConfig) {
    return new KafkaMeterRegistry(kafkaConfig, Clock.SYSTEM);
  }
}
