package cn.quantgroup.tech.brave.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * brave配置信息
 *
 * @author zhangheng
 * create on 2018.04.25
 */
@Data
@ConfigurationProperties( prefix = "tech.brave" )
public class BraveProperties {
    /**
     * 指定serviceName
     */
    private String serviceName = "brave";

    /**
     * kafka地址
     */
    private String kafkaBootstrapServers = "172.30.220.11:16091,172.30.220.11:16092,172.30.220.11:16093";

    /**
     * kafka的topic
     */
    private String kafkaTopic = "quantGroup.tech.brave.dev";

    /**
     * 采集率
     */
    private Float sample = 1.0f;
}

