package cn.quantgroup.apollopatch;

import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.internals.DefaultMetaServerProvider;

import java.util.HashMap;
import java.util.Map;

public class QGMetaServerProvider extends DefaultMetaServerProvider {

    private Map<Env, String> envMeta = new HashMap<>();

    {
        envMeta.put(Env.DEV, "http://apollo-dev.quantgroups.com");
        envMeta.put(Env.PRO, "http://apollo-pro.quantgroups.com");
    }

    @Override
    public String getMetaServerAddress(Env targetEnv) {
        String metaServerAddress = super.getMetaServerAddress(targetEnv);
        return metaServerAddress == null ? envMeta.get(targetEnv) : metaServerAddress;
    }

}
