package cn.quantgroup.apollopatch.spring;

import com.ctrip.framework.foundation.Foundation;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class QGSpringApplicationRunListener implements SpringApplicationRunListener {

    private final SpringApplication application;

    private final String[] args;

    public QGSpringApplicationRunListener(SpringApplication application, String[] args) {
        this.application = application;
        this.args = args;

        System.setProperty("apollo.bootstrap.enabled", "true");
        String property = Foundation.app().getProperty("namespace", "application");
        System.setProperty("apollo.bootstrap.namespaces", property);
        System.setProperty("apollo.bootstrap.eagerLoad.enabled", "true");
    }

    @Override
    public void starting() {
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {

    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void started(ConfigurableApplicationContext context) {

    }

    @Override
    public void running(ConfigurableApplicationContext context) {

    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {

    }

    /**
     * 兼容SpringBoot 1.5.8 版本的方法
     * @param context
     * @param exception
     */
    public void finished(ConfigurableApplicationContext context, Throwable exception){

    }


}
